<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */

use App\Models\Position;
use App\Models\UserDepartment;
use App\Repositories\Interfaces\IPositionRepository;

class PositionRepository extends Repository implements IPositionRepository {


    protected $modelClassName = 'Position';

    public function __construct(Position $position, UserDepartment $userDepartment)
    {
        $this->model = $position;
        $this->userDepartment = $userDepartment;
    }

    public function findByDepartmentName($username)
    {
        $where = call_user_func(__NAMESPACE__MODEL."{$this->modelClassName}::where", array($username));
        return $where->get();
    }

    public function findUserPositionByUserId($userId)
    {
        if ($userId) {
            $where =  $this->userDepartment->where('user_id', $userId);
            return $where->first();
        }
        return false;
    }

    public function findAndListPosition($searchAttr, $lists, $selectOptionValue = false){
        $result = $this->position;
        foreach ($searchAttr as $attr => $value) {
            if (is_null($value))
                $result = $result->whereNull($attr);
            else
                $result = $result->where($attr, $value);
        }
        $result = $result->pluck($lists['val'], $lists['key'])->all();
        return $selectOptionValue ? [$selectOptionValue => "Select"] + $result : $result;

    }



}
