<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\Parameter;
use App\Repositories\Interfaces\IParameterRepository;

class ParameterRepository extends Repository implements IParameterRepository {

    protected $modelClassName = 'Parameter';

    public function __construct(Parameter $model)
    {
        $this->model = $model;
    }

    public function listParameterValues($name){
        $find = $this->model->where('name', $name)->first();
        if ($find){
            return ($find->is_array ? explode(';', $find->value) : $find->value);
        }
        return null;
    }

}
