<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\Organization;
use App\Repositories\Interfaces\IOrganizationRepository;

class OrganizationRepository extends Repository implements IOrganizationRepository {


    protected $modelClassName = 'Organization';

    public function __construct(Organization $model)
    {
        $this->model = $model;
    }

    public function listOrganization($findAttributes = [], $join = 'inner', $orderBy = FALSE){
        $organization = Organization::with(['user', 'organizationLevel', 'reportToUser', 'details', 'position', 'relatedTables'])->select([
            'organization.id',
            'user_id',
            'organization_level_id',
            'organization.support_staff',
            'structure_position_id',
            'report_to_user_id',
            'level',
            'organization__level.name',
            'qty',
            'multiple_selection',
            'bg_color',
        ])
            ->join('organization__level',    'organization__level.id',    '=', 'organization.organization_level_id', $join)
            ->leftJoin('structure__positions', 'structure__positions.id',   '=', 'organization.structure_position_id');

        if (count($findAttributes)){
            $this->queryBuilder($organization, $findAttributes, [], $orderBy);

            /*foreach ($findAttributes as $attr => $each) {
                if (is_array($each)){
                    $prop = array_keys($each)[0];
                    if ($prop == 'not')
                        $organization->where($attr, '<>' , $each[$prop]);
                }
                else {
                    $organization->where($attr, $each);
                }
            }*/
        }

/*        if ($orderBy)
            $organization->orderBy($orderBy);*/

        return $organization->get();
    }

    public function listNotAssignedUsers($findAttributes = [], $selectCase = FALSE){
        return Organization::listNotAssignedUsers($findAttributes, $selectCase);
    }

    public function getAllReportToEmployees($organization_id = FALSE, $userId = FALSE){
        return Organization::getAllReportToEmployees($organization_id, $userId);
    }

    public function getAllDirectReportees($organization_id = FALSE, $userId = FALSE, $with = [])
    {
        return Organization::getAllDirectReportees($organization_id, $userId, $with);
    }

}
