<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\OrganizationLevel;
use App\Repositories\Interfaces\IOrganizationLevelRepository;

class OrganizationLevelRepository extends Repository implements IOrganizationLevelRepository {


    protected $modelClassName = 'OrganizationLevel';

    public function __construct(OrganizationLevel $model)
    {
        $this->model = $model;
    }

    /**
     * Get Array of Table Names By Given Table Ids
     * @param $id
     * @param $capitalize
     * @return array
     */
    public function getRelatedTableNames($id, $capitalize = FALSE){
        if ($id) {
            $object = $this->model->find($id);
            if ($object) {
                $tables = [];
                foreach ($object->details as $each) {
                    $tables[] = $capitalize ? ucwords($each->table->name) : $each->table->name;
                }
                return $tables;
            }
        }
        return [];
    }


    public function getEmployeesByLevelId($levelId, $accountable_staff = false, $organization_ids = false){
        return $this->model->getEmployeesByLevelId($levelId, $accountable_staff, $organization_ids);
    }
}
