<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */

use App\Models\Module;
use App\Models\UserModule;
use App\Repositories\Interfaces\IModuleRepository;

class ModuleRepository extends Repository implements IModuleRepository {


    protected $modelClassName = 'Module';

    public function __construct(Module $module, UserModule $userModule)
    {
        $this->model = $module;
        $this->userModule = $userModule;
    }

    public function findUserModules($userId)
    {
        if ($userId) {
            $where =  $this->userModule->with(['module'])
                                        ->where('user_id', $userId);;
            return $where->get();
        }
        return $userId;
    }

}
