<?php namespace App\Repositories\Interfaces;

/**
 * Created by PhpStorm.

 */

/**
 * The IUserRepository contains ONLY method signatures for methods
 * related to the User object.
 *
 * Note that we extend from IRepository, so any class that implements
 * this interface must also provide all the standard eloquent methods (find, all, etc.)
 */

interface IUserRepository extends IRepository {

    public function getAllUsers();

    public function getAuthUserId();

    public function findByUserName($email);

    public static function getUserFullInformation($userId);

    public static function getCeoUserId($userDepartmentRepository);

    public static function hasUserReportees($user_id, IOrganizationRepository $organizationRepository);

    //public function createOrUpdate($id = null);
}
