<?php namespace App\Repositories\Interfaces;

/**
 * Created by PhpStorm.

 */

/**
 * Interface IRepository provides the standard functions to be expected of ANY repository.
 * @package App\Repositories
 */

interface IRepository {

    public function relationship($functionName);

    public function insert(array $attributes);

    public function create(array $attributes);

    public function createByAttributes(array $attributes);

    public function get($with = [], $orderBy = [], $columns = ['*'], $trashed = false);

    public function first($with = [], $orderBy = [], $columns = ['*'], $trashed = false);

    public function getAttributeById($id, $attribute);

    public function all($columns = array('*'));

    public function find($id, $trashed = false);

    public function destroy($ids);

    public function updateById($id, $attributes);

    public function updateByAttributes($findAttributes, $updateAttributes);

    public function update($object, $attributes);

    public function delete();

    public function deleteObject($object);

    public function deleteByAttributes(array $attributes);

    public function deleteNotIn(array $attributes, array $values, $field = 'id');

    public function firstOrCreate(array $attributes);

    public function firstOrCreateMany(array $find_attributes, $key, $iterative_attribute);

    public function findByAttributes($attributes = [], $with = [], $select = ['*'], $join = [], $orderBy = []);

    public function findAllByAttributes($attributes = [], $with = [], $select = ['*'], $join = [], $orderBy = [], $limit = false, $groupBy = false);

    public function getTableName();

    public function findAndListModelVariable($searchAttr = [], $lists =  [0 => 'name'], $selectOptionValue = false, $limit = false, $orderBy = []);

    public function listModelVariable($lists = [0 => 'name'], $selectOptionValue = FALSE, $withoutOrder = FALSE);

        /**
     * Get By Given Conditions<br/>
     * Sample Each Condition <br/>
     * [<br/>
     *  'condition' => 'where',<br/>
     *  'field'     => 'user',<br/>
     *  'operator'  => 'LIKE',<br/>
     *  'values'    => 'abcd'<br/>
     * ]<br/>
     * @param $condition<br/>
     * @return mixed
     */
    public function getByCondition(array $condition, $orderBy = FALSE);


}
