<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\Flight;
use App\Models\FlightCrew;
use App\Repositories\Interfaces\IFlightCrewRepository;
use Illuminate\Support\Facades\Auth;

class FlightCrewRepository extends Repository implements IFlightCrewRepository {

    protected $modelClassName = 'FlightCrew';

    public function __construct(FlightCrew $model)
    {
        $this->model = $model;
    }

    public function isCrewOnPeriod($type, $from, $to){
        $check = $this->model->join('flights', 'flights.id', '=', $this->model->getTable().".flight_id")
                            ->whereRaw("DATE(s_flights.std) >= {$from} AND DATE(s_flights.std) <= {$to}");

        if ($type == CCM_CREW){
            $check->whereIn('position_id', [
                USER_PURSER_ID,
                USER_INSTRUCTOR_FLIGHT_ATTENDANT_ID,
                USER_SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_ID,
                USER_FLIGHT_ATTENDANT_ID,
                USER_FLIGHT_ATTENDANT_N2_ID,
                USER_FLIGHT_ATTENDANT_JUNIOR_ID,
            ]);
        }
        else if ($type == FCM_CREW){
            $check->whereIn('position_id', [
                USER_CAPTAIN_POSITION_ID,
                USER_CHIEF_PILOT_POSITION_ID,
                USER_PILOT_INSTRUCTOR_POSITION_ID,
                USER_FIRST_OFFICER_POSITION_ID,
                USER_COPILOT_JUNIOR_POSITION_ID,
            ]);
        }

        $check = $check->first();

        if ($check)
            return true;
        else
            return false;
    }


    public function deleteCrewOnPeriod($type, $from, $to){
        $currentTable = $this->model->getTable();
        $flights = Flight::whereRaw("DATE(s_flights.std) >= '{$from}' AND DATE(s_flights.std) <= '{$to}'")
                        ->get(["flights.id"])->toArray();


        $check = $this->model->whereIn('flight_id', $flights);

        if ($type == CCM_CREW){
            $check->whereIn('position_id', [
                USER_PURSER_ID,
                USER_INSTRUCTOR_FLIGHT_ATTENDANT_ID,
                USER_SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_ID,
                USER_FLIGHT_ATTENDANT_ID,
                USER_FLIGHT_ATTENDANT_N2_ID,
                USER_FLIGHT_ATTENDANT_JUNIOR_ID,
            ]);
        }
        else if ($type == FCM_CREW){
            $check->whereIn('position_id', [
                USER_CAPTAIN_POSITION_ID,
                USER_CHIEF_PILOT_POSITION_ID,
                USER_PILOT_INSTRUCTOR_POSITION_ID,
                USER_FIRST_OFFICER_POSITION_ID,
                USER_COPILOT_JUNIOR_POSITION_ID,
            ]);
        }

        $check->update([
            "{$currentTable}.updated_by"    => Auth::user()->id,
            "{$currentTable}.deleted_at"    => date("Y-m-d H:i:s")
        ]);

        if ($check)
            return true;
        else
            return false;
    }

}
