<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */

use App\Models\Department;
use App\Models\UserDepartment;
use App\Repositories\Interfaces\IDepartmentRepository;

class DepartmentRepository extends Repository implements IDepartmentRepository {


    protected $modelClassName = 'Department';

    public function __construct(Department $department, UserDepartment $userDepartment)
    {
        $this->department = $department;
        $this->userDepartment = $userDepartment;
    }

    public function findByDepartmentName($username)
    {
        $where = call_user_func(__NAMESPACE__MODEL."{$this->modelClassName}::where", array($username));
        return $where->get();
    }

    public function findUserDepartmentByUserId($userId)
    {
        if ($userId) {
            $where =  $this->userDepartment->where('user_id', $userId);
            return $where->first();
        }
        return false;
    }

    public function findUserDepartmentOrCreate($attributes){
        return $this->userDepartment->firstOrCreate($attributes);
    }

    public function updateUserDepartmentByUserId($userId, $attributes){
        return $this->userDepartment->where('user_id', $userId)->update($attributes);
    }

}
