<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\CrewRoster;
use App\Repositories\Interfaces\ICrewRosterRepository;

class CrewRosterRepository extends Repository implements ICrewRosterRepository {

    protected $modelClassName = 'CrewRoster';

    public function __construct(CrewRoster $model)
    {
        $this->model = $model;
    }

    public function isRosterConflicts($type, $from, $to){
        $conflictSearch = $this->model->where('status', APPLICATION_STATUS_PUBLISHED)
                    ->where('type', $type)
                    ->where(function($query) use ($from, $to) {
                        $query->where(function ($sql) use ($from, $to) {
                            $sql->where("roster_from", "<=", $from)
                                ->where("roster_to", ">", $to);
                        })->orWhere(function ($sql) use ($from, $to) {
                                $sql->where("roster_from", ">=", $from)
                                    ->where("roster_from", "<=", $to);
                        });
                    })->first();

        if ($conflictSearch)
            return true;
        else
            return false;
    }

}
