<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\CrewRestrictionRoute;
use App\Repositories\Interfaces\ICrewRestrictionRouteRepository;
use Illuminate\Support\Facades\DB;

class CrewRestrictionRouteRepository extends Repository implements ICrewRestrictionRouteRepository {

    protected $modelClassName = 'CrewRestrictionRoute';

    public function __construct(CrewRestrictionRoute $model)
    {
        $this->model = $model;
    }

    public function listRouteRestrictions($userId = FALSE){

        $result = $this->model->select(DB::raw('CONCAT(s_fromAirport.iata, "-", s_fromAirport.iata) as route'), 'flight_route_id AS id')
            ->join('flights__routes', 'flights__routes.id', '=','crew__restrictions__route.flight_route_id')
            ->join('airports as fromAirport', 'fromAirport.id', '=','flights__routes.from_airport_id')
            ->join('airports as toAirport', 'toAirport.id', '=','flights__routes.to_airport_id');

        if ($userId){
            $userId = is_array($userId) ? $userId : [$userId];
            $result->whereIn('user_id', $userId);
        }

        return $result->pluck('route', 'id')->all();
    }

}
