<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    const HOME = '/home';

    protected $namespace = 'App\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     *
     * @return void
     */
    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {
            Route::prefix('api')
                ->middleware('api')
                ->namespace($this->namespace) // need to add in Laravel 8
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->namespace($this->namespace) // need to add in Laravel 8
                ->group(base_path('routes/web.php'));
        });

        Route::model('agency',  \App\Models\Agency::class);
        Route::model('agency_code',  \App\Models\AgencyCode::class);
        Route::model('aircraft', \App\Models\Aircraft::class);
        Route::model('maintenance', \App\Models\Maintenance::class);
        Route::model('aircraft_type', \App\Models\AircraftType::class);
        Route::model('aircraft_certificate', \App\Models\AircraftCertificate::class);
        Route::model('aircraft_engine', \App\Models\AircraftEngine::class);

        Route::model('airline', \App\Models\Airline::class);
        Route::model('airline_service', \App\Models\AirlineService::class);
        Route::model('airline_library', \App\Models\AirlineLibrary::class);

        Route::model('airport', \App\Models\Airport::class);
        Route::model('airport_license', \App\Models\AirportLicense::class);

        Route::model('chart', \App\Models\Chart::class);
        Route::model('container', \App\Models\Container::class);

        Route::model('department', \App\Models\Department::class);
        Route::model('position', \App\Models\Position::class);

        Route::model('delay', \App\Models\Delay::class);

        Route::model('email_notification', \App\Models\EmailNotification::class);

        Route::model('flight', \App\Models\Flight::class);
        Route::model('flight_staff', \App\Models\FlightStaff::class);
        Route::model('flight_number', \App\Models\FlightNumber::class);
        Route::model('flight_route', \App\Models\FlightRoute::class);
        Route::model('flight_schedule', \App\Models\FlightSchedule::class);
        Route::model('flight_schedule_flight', \App\Models\FlightScheduleFlight::class);

        Route::model('homepage_chart', \App\Models\HomeChart::class);

        Route::model('license', \App\Models\License::class);
        Route::model('location', \App\Models\Location::class);

        Route::model('mhb', \App\Models\MHB::class);
        Route::model('module', \App\Models\Module::class);

        Route::model('organization', \App\Models\Organization::class);
        Route::model('passenger', \App\Models\Passenger::class);

        Route::model('revenue_target', \App\Models\RevenueTarget::class);
        Route::model('revenue_target_period', \App\Models\RevenueTargetPeriod::class);

        Route::model('service', \App\Models\Service::class);
        Route::model('service_license', \App\Models\AirlineLicense::class);
        Route::model('staff_license', \App\Models\StaffLicense::class);

        Route::model('scm', \App\Models\SCM::class);
        Route::model('user', \App\Models\User::class);
        Route::model('user_leave_request', \App\Models\UserLeaveRequest::class);

        Route::model('standby_crew', \App\Models\StandbyCrew::class);

        Route::model('library', \App\Models\Library::class);
        Route::model('flight_com', \App\Models\FlightCom::class);
        Route::model('flight_com_picture', \App\Models\FlightComPicture::class);

        Route::model('notification', \App\Models\Notification::class);
        Route::model('holiday', \App\Models\Holiday::class);
        Route::model('holiday_airport', \App\Models\HolidayAirport::class);


    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
