<?php namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class BladeServiceProvider extends ServiceProvider {

	/**
	 * Bootstrap the application services.
	 *
	 * @return void
	 */
	public function boot()
	{
        \Blade::extend(function($value) {
            return preg_replace('/\@define(.+)/', '<?php ${1}; ?>', $value);
        });

        \Blade::extend(function($value)
        {
            return preg_replace('/(\s*)@break(\s*)/', '$1<?php break; ?>$2', $value);
        });

        \Blade::extend(function($value)
        {
            return preg_replace('/(\s*)@(break|continue)(\s*)/', '$1<?php $2; ?>$3', $value);
        });

        \Blade::extend(function($value, $compiler)
        {
            $value = preg_replace('/(?<=\s)@switch\((.*)\)(\s*)@case\((.*)\)(?=\s)/', '<!--?php switch($1):$2case $3: ?-->', $value);
            $value = preg_replace('/(?<=\s)@endswitch(?=\s)/', '<!--?php endswitch; ?-->', $value);

            $value = preg_replace('/(?<=\s)@case\((.*)\)(?=\s)/', '<!--?php case $1: ?-->', $value);
            $value = preg_replace('/(?<=\s)@default(?=\s)/', '<!--?php default: ?-->', $value);
            $value = preg_replace('/(?<=\s)@break(?=\s)/', '<!--?php break; ?-->', $value);

            return $value;
        });
    }

	/**
	 * Register the application services.
	 *
	 * @return void
	 */
	public function register()
	{
		//
	}

}
