<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ReadAndSignNotification extends Notification
{
    use Queueable;

    protected $subject;
    protected $message;
    protected $library;
    protected $type;
    protected $column;

    /**
     * ReadAndSignNotification constructor.
     * @param $library
     * @param string $type
     */
    public function __construct($library, $type = LIBRARY)
    {
        $this->type = $type;
        $this->column = $type == LIBRARY ? "library_id" : "airline_library_id";

        $this->library = $library;
        $this->subject = "Read and sign document";
        $this->message = "Please read the following document and confirm.";
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        if (!$this->library->attachment_file){
            return ['database'];
        }

        return ['database', 'mail'];
    }

    public function toMail($notifiable)
    {
        $url = route("homepage")."#user-notifications";

        return (new MailMessage)
            ->subject($this->subject)
            ->markdown('emails.notification.document_read_and_sign',
                [
                    'obj'           => $notifiable,
                    'actionUrl'     => $url,
                ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            "message"            => $this->message,
            "{$this->column}"    => $this->library->id,
            "type"               => $this->type,
        ];
    }
}
