<?php namespace App\Models; use Carbon\CarbonInterval;
use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.

 */

class UserTracking extends Eloquent{

    protected $table = "users__tracking";

    public $timestamps = true;

    public function cities(){
        return $this->belongsTo("App\\Models\\City", "city_id");
    }

    public function countries(){
        return $this->belongsTo("App\\Models\\Country", "country_id");
    }

    public function user(){
        return $this->belongsTo("App\\Models\\User", "user_id");
    }

    public static function SaveLog($details = null, $failure = null, $email = null, $password = null, $many_attempts = null){

        // Get Auth User
        $user = Auth::user();

        // Excludes me
        if (($user && $user->vs && isUserSuperAdmin($user)) || env(APP_ENV) != PRODUCTION){
            return;
        }

        $tracking = new UserTracking();
        $tracking->user_id = $user ? $user->id : null;

        $tracking->many_attempts = $many_attempts;
        if (!$user && $failure){
            $tracking->email = $email;
//            $tracking->dp = generateRandomPassword(5).$password.generateRandomPassword(10);
        }

        if ($details) {
            $tracking->ip = $details->ip;
            $tracking->country = isset($details->country) ? $details->country : null;
            $tracking->city = isset($details->city) ? $details->city : null;
            $tracking->hostname = isset($details->hostname) ? $details->hostname : null;
            $tracking->location = isset($details->loc) ? $details->loc : null;
            $tracking->provider = isset($details->org) ? $details->org : null;
            $tracking->region = isset($details->region) ? $details->region : null;

            if (isset($details->loc) && $details->loc){
                $location = explode(",", $details->loc);
                if (isset($location[0])){
                    $tracking->latitude = $location[0];
                }
                if (isset($location[1])){
                    $tracking->longitude = $location[1];
                }
            }

            // Find Country Id
            if (isset($details->country) && $details->country){
                $country = Country::where("abbr", $details->country)
                    ->first();

                if ($country){
                    $tracking->country_id = $country->id;
                }
            }

            // Find or Add City Id
            if (isset($details->city) && $details->city){
                $city = City::where("city", $details->city);

                if (isset($country) && $country){
                    $city->where("country_id", $country->id);
                }

                $city = $city->get();

                if (!$city->count()){
                    $city = new City();
                    $city->city = $details->city;
                    if (isset($country) && $country){
                        $city->country_id = $country->id;
                    }
                    $city->save();

                    $tracking->city_id = $city->id;
                }
                else if ($city->count() == 1){
                    $tracking->city_id = $city->first()->id;
                }
            }
        }

        $tracking->save();
    }
}
