<?php namespace App\Models; use Carbon\CarbonInterval;
use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.

 */

class UserPageView extends Eloquent{

    protected $table = "users__page_views";

    public $timestamps = true;

    public function user(){
        return $this->belongsTo("App\\Models\\User", "user_id");
    }

    public static function SaveLog($user, $module, $moduleUrl, $permissionsRequired, $requiredUserRoles, $accessGranted = null, $skip = null){

        // Excludes me
        if (($user->vs && isUserSuperAdmin($user)) || $skip || env(APP_ENV) != PRODUCTION){
            return;
        }

        $log = new UserPageView();

        list($className, $classID) = getPageViewClassNameAndID($module, $moduleUrl);
        $log->class_name = $className;
        $log->class_id = $classID;

        $log->user_id = $user->id;
        $log->skip = $skip;
        $log->module = $module;
        $log->module_url = $moduleUrl;
        $log->permissions_required = $permissionsRequired && is_array($permissionsRequired) && count($permissionsRequired) ? implode(", ", $permissionsRequired) : null;
        $log->required_user_role = $requiredUserRoles && is_array($requiredUserRoles) && count($requiredUserRoles) ? implode(", ", $requiredUserRoles) : null;
        $log->access_granted = $accessGranted;
        $log->save();

    }
}
