<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class UserModule extends Eloquent implements AuditableContract {

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "users__modules";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at",
        "deleted_at"
    ];

    public function module(){
        return $this->belongsTo('App\Models\Module');
    }

    public function permission(){
        return $this->belongsTo('App\Models\ModulePermission', 'module_permission_id');
    }

    public static function getAuthUserModule(){
        $modules = ModulePermission::with("module")
                                    ->where('name', VIEW_PERMISSION)
                                    ->get();

        $userModulePermissions = UserModule::where("user_id", Auth::user()->id)
                                    ->get(["users__modules.*"])
                                    ->keyBy("module_permission_id")
                                    ->toArray();

        $userModules = [];
        foreach ($modules as $each) {
            if ($each->module && !$each->module->hidden_module){
                if (isset($userModulePermissions[$each->id])){
                    $userModules[]  = $each->module_id;
                }
            }
        }

        return $userModules;
    }

    public static function getAuthUserModulePermissions(){
        $userModulePermissions = UserModule::with(['module', 'permission'])
            ->where("user_id", Auth::user()->id)
            ->get();


        $userModules = [];
        foreach ($userModulePermissions as $each) {
            if (!$each->module || !$each->permission){
                continue;
            }

            if (!isset($userModules[$each->module->name]))
            {
                $userModules[$each->module->name] = [];
            }

            $userModules[$each->module->name][] = $each->permission->name;
        }


        return $userModules;
    }

}
