<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class UserLeaveStatus extends Eloquent{

    protected $table = "users__leave_status";

    public $timestamps = true;

    protected $fillable = [
        'request_id',
        'status_id',
        'report_to_user_id',
        'line',
        'is_ceo',
        'is_hr'
    ];

    public function leaveRequest(){
        return $this->belongsTo('App\Models\UserLeaveRequest', 'request_id');
    }

    public function status(){
        return $this->belongsTo('App\Models\ApplicationStatus', 'status_id');
    }

    public function user(){
        return $this->belongsTo('App\Models\User', 'report_to_user_id');
    }

    public function organization(){
        return $this->belongsTo('App\Models\Organization', 'report_to_user_id', 'user_id');
    }

}
