<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class UserLeaveRequest extends Eloquent{

    protected $table = "users__leave_requests";

    public $timestamps = true;

    protected $fillable = [
        'user_id',
        'leave_id',
        'calendar_days',
        'working_days',
        'exceeded',
        'exceeded_days',
        'date_from',
        'date_to',
        'type',
        'days'
    ];

    public function leave(){
        return $this->belongsTo(Leave::class, 'leave_id');
    }

    public function user(){
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function status(){
        return $this->belongsTo('App\Models\ApplicationStatus', 'status_id');
    }

    public function leaveStatus(){
        return $this->hasMany('App\Models\UserLeaveStatus', 'request_id');
    }
}
