<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class UserDepartment extends Eloquent implements AuditableContract
{
    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "users__departments";

    protected $fillable = [
        'user_id',
        'department_id',
        'subdepartment_id',
        'position_id'
    ];

    public function department(){
        return $this->belongsTo('App\Models\Department', 'department_id');
    }

    public function position(){
        return $this->belongsTo('App\Models\Department', 'position_id');
    }

    public function user(){
        return $this->belongsTo('App\Models\User', 'user_id');
    }

}
