<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class UserChat extends Eloquent{

    protected $table = "users__chat";

    public $timestamps = true;

    protected $fillable =  [
        'from_user_id',
        'to_user_id',
        'message',
        'key',
        'sent'
    ];

    public function fromUser(){
        return $this->belongsTo('App\Models\User', 'from_user_id');
    }

    public function toUser(){
        return $this->belongsTo('App\Models\User', 'to_user_id');
    }
}
