<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class SubDepartment extends Model implements AuditableContract
{
    use SoftDeletes, Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "structure__subdepartments";

    protected $dates = ["deleted_at"];

    protected $gaurded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public $timestamps = TRUE;

    /**
     * Get Related Department
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function department()
    {
        return $this->belongsTo("App\\Models\\Department", "department_id");
    }
}
