<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 01.09.14

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class StandbyCrew extends Eloquent implements AuditableContract
{
    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected  $table = "flights__standby_crew";

    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo("App\\Models\\User", "user_id");
    }

    public function position()
    {
        return $this->belongsTo("App\\Models\\Position", "position_id");
    }

    public function airport()
    {
        return $this->belongsTo('App\Models\Airport', 'airport_id');
    }
}
