<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class StaffStation extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "staff__stations";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public function airport(){
        return $this->belongsTo('App\Models\Airport', 'airport_id');
    }

    public static function createCurrentStaffStation($airport){
        $staffStation = StaffStation::where("airport_id", $airport->id)
            ->where("user_id", Auth::user()->id)
            ->first();

        if (!$staffStation){
            $staffStation = new StaffStation();
            $staffStation->airport_id = $airport->id;
            $staffStation->user_id = Auth::user()->id;
            $staffStation->save();
        }
    }



    public static function currentStaffStationsList($type = null, $userId = null, $onlyStaffLocations = null){
        $staffLocationsAirportIDs = $onlyStaffLocations ? Location::getStaffAirportIDs() : null;

        if (!$type){
            $stations = StaffStation::where("user_id", ($userId ? $userId : Auth::user()->id));

            if ($onlyStaffLocations && $staffLocationsAirportIDs && count($staffLocationsAirportIDs)){
                $stations->whereIn("airport_id", $staffLocationsAirportIDs);
            }

            return $stations->pluck("airport_id")
                            ->all();
        }

        switch($type){
            case IATA:
                $stations = StaffStation::join("airports", "airports.id", "=", "staff__stations.airport_id")
                    ->where("user_id", ($userId ? $userId : Auth::user()->id));
//                    ->orderBy("airports.position", "DESC")

                if ($onlyStaffLocations && $staffLocationsAirportIDs && count($staffLocationsAirportIDs)){
                    $stations->whereIn("airport_id", $staffLocationsAirportIDs);
                }

                $stations = $stations->orderBy("airports.iata")
                        ->get([
                            DB::raw("IF(iata is NULL OR iata = '', icao, iata) as code"),
                            "airport_id"
                        ])
                        ->pluck("code", "airport_id")
                        ->all();
                break;

            case NAME:
                $stations = StaffStation::join("airports", "airports.id", "=", "staff__stations.airport_id")
                    ->where("user_id", ($userId ? $userId : Auth::user()->id));
//                    ->orderBy("airports.position", "DESC")

                if ($onlyStaffLocations && $staffLocationsAirportIDs && count($staffLocationsAirportIDs)){
                    $stations->whereIn("airport_id", $staffLocationsAirportIDs);
                }

                $stations = $stations->orderBy("airports.name")
                        ->pluck("airports.name", "airport_id")
                        ->all();
                break;

            case NAME_IATA:
                $stations = StaffStation::join("airports", "airports.id", "=", "staff__stations.airport_id")
                    ->select([
                        DB::raw("CONCAT(name, '(', IF(iata is NULL OR iata = '', icao, iata), ')') AS manual_code "),
                        "airport_id",
                    ]);
//                    ->orderBy("airports.position", "DESC")

                if ($onlyStaffLocations && $staffLocationsAirportIDs && count($staffLocationsAirportIDs)){
                    $stations->whereIn("airport_id", $staffLocationsAirportIDs);
                }

                $stations = $stations->where("user_id", ($userId ? $userId : Auth::user()->id))
                        ->orderBy("manual_code")
                        ->pluck("manual_code", "airport_id")
                        ->all();
                break;

            case WITH_COUNTRY:
                $stations = StaffStation::with(["airport", "airport.country"]);

                if ($onlyStaffLocations && $staffLocationsAirportIDs && count($staffLocationsAirportIDs)){
                    $stations->whereIn("airport_id", $staffLocationsAirportIDs);
                }

                $stations = $stations->where("user_id", ($userId ? $userId : Auth::user()->id))
                         ->get();
                break;

            case WITH_COUNTRY_AND_CITY:
                $stations = StaffStation::with(["airport", "airport.country", "airport.city"]);

                if ($onlyStaffLocations && $staffLocationsAirportIDs && count($staffLocationsAirportIDs)){
                    $stations->whereIn("airport_id", $staffLocationsAirportIDs);
                }

                $stations = $stations->where("user_id", ($userId ? $userId : Auth::user()->id))
                        ->get();
                break;

            default:
                $stations = StaffStation::join("airports", "airports.id", "=", "staff__stations.airport_id")
                    ->where("user_id", ($userId ? $userId : Auth::user()->id));
//                    ->orderBy("airports.position", "DESC")

                if ($onlyStaffLocations && $staffLocationsAirportIDs && count($staffLocationsAirportIDs)){
                    $stations->whereIn("airport_id", $staffLocationsAirportIDs);
                }

                $stations = $stations->orderBy("airports.iata")
                        ->pluck("airport_id")
                        ->all();
                break;
        }

        return $stations;
    }
}
