<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class StaffAirline extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "staff__airlines";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public function airline(){
        return $this->belongsTo('App\Models\Airline', 'airline_id');
    }

    public static function createCurrentStaffAirline($airline){
        $staffAirline = StaffAirline::where("airline_id", $airline->id)
            ->where("user_id", Auth::user()->id)
            ->first();

        if (!$staffAirline){
            $staffAirline = new StaffAirline();
            $staffAirline->airline_id = $airline->id;
            $staffAirline->user_id = Auth::user()->id;
            $staffAirline->save();
        }
    }


    public static function currentStaffAirlinesList($type = null, $userId = null){
        if (!$type){
            $arr = StaffAirline::where("user_id", ($userId ? $userId : Auth::user()->id))
                                ->pluck("airline_id")
                                ->all();

            return mergeOperatorAirlineList($arr);
        }
        switch($type){

            case AIRLINE_IDS:
                return StaffAirline::where("user_id", ($userId ? $userId : Auth::user()->id))
                                    ->pluck("airline_id")
                                    ->all();
                break;

            case IATA:
                return StaffAirline::join("airlines", "airlines.id", "=", "staff__airlines.airline_id")
                    ->where("user_id", ($userId ? $userId : Auth::user()->id))
                    ->orderBy("iata")
                    ->orderBy("icao")
                    ->get([
                        DB::raw("IF(iata is NULL OR iata = '', icao, iata) as code"),
                        "airline_id"
                    ])
                    ->pluck("code", "airline_id")
                    ->all();
                break;

            case NAME:
                $arr = StaffAirline::join("airlines", "airlines.id", "=", "staff__airlines.airline_id")
                    ->where("user_id",($userId ? $userId : Auth::user()->id))
                    ->orderBy("airline")
                    ->pluck("airlines.airline", "airline_id")
                    ->all();

                return mergeOperatorAirlineList($arr, "airline", "id");

            case NAME_IATA:
                return StaffAirline::join("airlines", "airlines.id", "=", "staff__airlines.airline_id")
                    ->select([
                        DB::raw("CONCAT(airline, '(', IF(iata is NULL OR iata = '', icao, iata), ')') AS manual_code"),
                        "airline_id",
                    ])
                    ->where("user_id", ($userId ? $userId : Auth::user()->id))
                    ->orderBy("iata")
                    ->orderBy("icao")
                    ->pluck("manual_code", "airline_id")
                    ->all();
                break;

            case WITH_COUNTRY:
                return StaffAirline::with(["airline", "airline.airlineService", "airline.country"])
                                    ->join("airlines", "airlines.id", "=", "staff__airlines.airline_id")
                                    ->where("user_id", ($userId ? $userId : Auth::user()->id))
                                    ->orderBy("airlines.airline")
                                    ->get([
                                        "staff__airlines.*"
                                    ]);

            case LIBRARY:
                return StaffAirline::with(["airline", "airline.library"])
                    ->join("airlines", "airlines.id", "=", "staff__airlines.airline_id")
                    ->where("user_id", ($userId ? $userId : Auth::user()->id))
                    ->orderBy("airlines.airline")
                    ->get([
                        "staff__airlines.*"
                    ]);
                break;

        }

    }
}
