<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Service extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "services";

    public $timestamps = true;

    public function airlineLicense(){
        return $this->hasMany("App\\Models\\AirlineLicense", "service_id");
    }

    public static function getServicesListByID($selectedIDs = null){
        if (!$selectedIDs){
            return Service::orderBy("position")->pluck("abbr", "id")->all();
        }

        $selectedIDs = is_array($selectedIDs) ? $selectedIDs : [$selectedIDs];

        return Service::whereIn("id", $selectedIDs)->orderBy("position")->pluck("abbr", "id")->all();
    }

    public static function getServicesByID($selectedIDs = null){
        if (!$selectedIDs){
            return Service::orderBy("position")->get();
        }

        $selectedIDs = is_array($selectedIDs) ? $selectedIDs : [$selectedIDs];

        return Service::whereIn("id", $selectedIDs)->orderBy("position")->get();
    }

}
