<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;


/**
 * Created by PhpStorm.

 */

class SalesCall extends Eloquent{

    protected $table = "sales__calls";

    public $timestamps = true;

    public static function createSalesCallFromInput($organization){
        $salesCall = new SalesCall();
        $salesCall->organization_id = $organization->id;
        $salesCall->agency_id = \request("agency_id");
        $salesCall->status_id = \request("status_id");
        $salesCall->planned_from = \request("date_from");
        $salesCall->planned_to = \request("date_to");
        $salesCall->description = \request("description");
        $salesCall->icon = \request("icon");
        $salesCall->color = \request("color");
        $salesCall->save();

        return $salesCall;
    }

    public static function prepareSalesCallsForCalendar($organization){
        $json = [];

        $salesCalls = SalesCall::where("organization_id", $organization->id)->get();

        foreach ($salesCalls as $each) {
            $json[] = [
                'title'         => $each->title,
                'start'         => $each->planned_from,
                'end'           => $each->planned_to,
                'description'   => $each->description,
                'className'     => ["event", $each->color],
                'icon'          => $each->icon
            ];
        }

       return $json;
    }
}
