<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

class SCM extends Eloquent
{

    protected $table = "scm";

    public $timestamps = true;

    public function details()
    {
        return $this->hasMany("App\\Models\\SCMDetail", "scm_id");
    }

    public function airline()
    {
        return $this->belongsTo("App\\Models\\Airline", "airline_id");
    }

    public function airport()
    {
        return $this->belongsTo("App\\Models\\Airport", "airport_id");
    }

    public function createdBy()
    {
        return $this->belongsTo("App\\Models\\User", "created_by");
    }

    public static function searchByDateAirlineAirport($dateSearch, $airlines, $airports){

        $SCMs = SCM::select();

        if ($dateSearch) {
            if (isset($dateSearch['month'], $dateSearch['year'])) {
                $month = is_array($dateSearch['month']) ? $dateSearch['month'] : [$dateSearch ['month']];
                $year = is_array($dateSearch['year']) ? $dateSearch['year'] : [$dateSearch ['year']];

                $SCMs->whereIn(DB::raw("MONTH(scm_datetime)"), $month)
                    ->whereIn(DB::raw("YEAR(scm_datetime)"), $year);

            } elseif (isset($dateSearch['from'], $dateSearch['to'])) {
                $SCMs->whereBetween("scm_datetime", [$dateSearch['from'] . " 00:00:00", $dateSearch['to'] . " 23:59:59"]);
            }
        }

        if ($airlines){
            $airlines = is_array($airlines) ? $airlines : [$airlines];

            if (count($airlines)) {
                $SCMs->whereIn("airline_id", $airlines);
            }
        }

        if ($airports){
            $airports = is_array($airports) ? $airports : [$airports];

            if (count($airports)) {
                $SCMs->whereIn("airport_id", $airports);
            }
        }

        return $SCMs->get();
    }
}
