<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Created by PhpStorm.

 */

class RevenueTarget extends Eloquent{

    use SoftDeletes;

    protected $table = "revenue__targets";

    protected $dates = ["deleted_at"];

    public $timestamps = true;

    public function type(){
        return $this->belongsTo('App\Models\ReportType', 'type_id');
    }
    public function bindedTo(){
        return $this->belongsTo('App\Models\RevenueTarget', 'target_id');
    }
    public function children(){
        return $this->hasMany('App\Models\RevenueTarget', 'parent_id');
    }
    public function organization(){
        return $this->belongsTo('App\Models\Organization', 'organization_id');
    }
    public function period(){
        return $this->belongsTo('App\Models\RevenueTargetPeriod', 'period_id');
    }
}
