<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */
class ResultMessage extends Eloquent
{
    protected $table = "messages__result";

    public $timestamps = false;

    protected $guarded = [
        "id"
    ];


    /**
     * Check if email is being processed by the system
     * @param null $messageID
     * @param null $udate
     * @param null $senderEmail
     * @return mixed
     */
    public static function messageExists($messageID = null, $udate = null, $senderEmail = null){

        $result = self::select();

        if ($messageID){
            $result->whereNotNull("message_id")
                   ->where("message_id", $messageID);
        }
        else {
            $result->where("udate", $udate)
                   ->where("from_email", $senderEmail);
        }

        return $result->first();
    }

    /**
     * Create from given vars
     * @param null $messageID
     * @param null $udate
     * @param null $senderEmail
     * @param null $parsed
     * @return ResultMessage
     */
    public static function createMessage($messageID = null, $udate = null, $senderEmail = null, $parsed = null){
        $result = new ResultMessage();
        $result->parsed = $parsed;
        if ($messageID){
            $result->message_id = $messageID;
        }
        if ($udate){
            $result->udate = $udate;
        }
        if ($senderEmail){
            $result->from_email = $senderEmail;
        }

        $result->created_at = date("Y-m-d H:i:s");
        $result->save();

        return $result;
    }
}
