<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 18.08.14

 */

use Illuminate\Database\Eloquent\SoftDeletes;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Position extends Eloquent implements AuditableContract
{
    use SoftDeletes, Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "structure__positions";

    protected $dates = ["deleted_at"];

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public $timestamps = TRUE;

    public function reportsTo()
    {
        return $this->belongsTo(Position::class, 'reports_to_id');
    }


    public function standby()
    {
        return $this->hasOne("App\\Models\\StandbyCrew", "position_id");
    }

    public function subDepartment(){
        return $this->belongsTo('App\\Models\\SubDepartment', 'subdepartment_id');
    }

    public function department(){
        return $this->belongsTo('App\\Models\\Department', 'department_id');
    }

    public static function getPositionsByDepartment($departmentId = null, $subDepartmentId = null){
        $positions = self::select();
        if ($departmentId)
            $positions->where("department_id", $departmentId);

        if ($subDepartmentId) {
            $positions->where('subdepartment_id', $subDepartmentId);
        }
        else{
            $positions->whereNull('subdepartment_id');
        }

        return ["" => "Select"] + $positions->pluck("name", "id")->all();
    }

    public static function getOrCreatePosition($name, $department){

        $position = Position::where(function($sql) use ($name) {
                                $sql->where('name', $name)
                                    ->orWhere("name", ucwords(strtolower($name)));
                            });

        if ($department){
            $position->department_id = $department->id;
        }

        $position = $position->first();

        if (!$position){
            $position = new Position();
        }

        $position->name = ucwords($name);
        $position->department_id = $department ? $department->id : null;
        $position->save();

        return $position;
    }

    public static function getOrCreatePositionByDepartment($name, $departmentID, $subdepartmentID){
        $position = Position::where("name", $name);

        if ($departmentID){
            $position->where("department_id", $departmentID);
        }

        if ($subdepartmentID){
            $position->where("subdepartment_id", $subdepartmentID);
        }
        $position = $position->first();

        if (!$position){
            $position = new Position();
            $position->name = $name;
            $position->department_id = $departmentID ? $departmentID : null;
            $position->subdepartment_id = $subdepartmentID ? $subdepartmentID : null;
            $position->save();
        }

        return $position;
    }
}
