<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

class PassengerPhone extends Eloquent {
    protected $table = "passengers__phones";
    public $timestamps = true;


    protected $fillable = ['passenger_id', 'phone_type_id', 'number'];

    public function passenger(){
        return $this->belongsTo('Passenger', 'passenger_id');
    }

    public function phoneType(){
        return $this->hasOne('PhoneType', 'id', 'phone_type_id');
    }

}
