<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 27.08.14

 */

class PassengerOrder extends Eloquent
{
    protected $table = "passengers__orders";
    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];
    public $timestamps = TRUE;

    /**
     * Aircraft
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function passenger()
    {
        return $this->belongsTo("App\\Models\\Passenger", "passenger_id");
    }
    public function passengerFlight()
    {
        return $this->hasMany("App\\Models\\PassengerFlight", "passenger_order_id");
    }

    public function agencyCode(){
        return $this->hasOne('App\\Models\\AgencyCode', 'id', 'agency_code_id');
    }

    public function localCurrency(){
        return $this->belongsTo('App\Models\Currency', 'original_fare_currency_id');
    }


    public static function revenueByCountry($dates, $isDatesPeriod = false, $revenue_type = REVENUE_SOLD){
        $orders = PassengerOrder::select([
            DB::raw('SUM(s_passengers__orders.fare) AS revenue'),
            DB::raw('count(*) as pax'),
            'country',
            'abbr'
        ])

            ->join('agency__codes', 'agency__codes.id', '=', 'passengers__orders.agency_code_id')
            ->join('countries', 'countries.id', '=', 'agency__codes.country_id');

        switch($revenue_type){
            case REVENUE_SOLD:
                $column = 'sales_date';
                break;

            case REVENUE_FLOWN:
                $orders->join('passengers__flights', 'passengers__flights.passenger_order_id', '=', 'passengers__orders.id');
                $column = 'departure_date';
                break;
        }

        if (is_array($dates)){
            if ($isDatesPeriod && count($dates) == 2) {
                $orders->whereBetween($column, $dates);
            }
            else {
                $orders->whereIn($column, $dates);
            }
        }
        else {
            $orders->where($column, $dates);
        }

        $orders->groupBy('country')
               ->orderBy('revenue', 'DESC');

        return $orders->get();
    }

    public static function searchTicketNumber($ticket_number){

        $data = self::with(['agencyCode', 'passengerFlight'])
            ->where("ticket_number",$ticket_number)
            ->first();

        return $data;
    }


}
