<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

use Illuminate\Database\Eloquent\SoftDeletes;

class PassengerLanguage extends Eloquent {
    protected $table = "passengers__languages";
    public $timestamps = true;

    use SoftDeletes;

    public $fillable = ['passenger_id', 'language_id'];

    public function passenger(){
        return $this->belongsTo('App\Models\Passenger', 'passenger_id');
    }

    public function language(){
        return $this->hasOne('App\Models\Language', 'id', 'language_id');
    }

}
