<?php namespace App\Models;
use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use stdClass;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 27.08.14

 */
class PassengerFlightAct extends Eloquent
{
    protected $table = "passengers__flights_act";

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];
    public $timestamps = TRUE;

    /**
     * Aircraft
     * return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function fareCurrency()
    {
        return $this->belongsTo("App\\Models\\Currency", "fare_currency_id");
    }

    public function passenger()
    {
        return $this->belongsTo("App\\Models\\Passenger", "passenger_id");
    }

    public function passengerFlight()
    {
        return $this->belongsTo("App\\Models\\PassengerFlight", "passenger_flight_id");
    }

    public function passengerOrder()
    {
        return $this->belongsTo("App\\Models\\PassengerOrder", "passenger_order_id");
    }

    public function passengerFrequentFlyer()
    {
        return $this->belongsTo("App\\Models\\PassengerFrequentFlyer", "passenger_frequent_flyer_id");
    }

    public function flight()
    {
        return $this->belongsTo("App\\Models\\Flight", "flight_id");
    }

    public function flightRbd()
    {
        return $this->belongsTo("App\\Models\\FlightRbd", "flight_rbd_id");
    }

    public function flightCabin()
    {
        return $this->belongsTo("App\\Models\\FlightCabin", "flight_cabin_id");
    }

    public function flightOrderStatus()
    {
        return $this->belongsTo("App\\Models\\FlightOrderStatus", "flight_order_status_id");
    }

    public function flightFareBasis()
    {
        return $this->belongsTo("App\\Models\\FlightFareBasis", "flight_fare_basis_id");
    }

    public function flightNumber()
    {
        return $this->belongsTo("App\\Models\\FlightNumber", "flight_number_id");
    }

    public function agencyCode()
    {
        return $this->hasManyThrough("App\\Models\\AgencyCode", "App\\Models\\PassengerOrder", 'id', 'agency_code_id');
    }


    public static function getActList($createdFrom = null, $createdTo = null, $flightIDs = null){
        $prl = PassengerFlightAct::with([
            "flightNumber"
        ])->whereNull("deleted_at")
          ->whereNull("passenger_flight_id");

        if ($flightIDs){
            if (is_array($flightIDs)){
                if (count($flightIDs)){
                    $prl->whereIn("flight_id", $flightIDs);
                }
            }
            else {
                $prl->where("flight_id", $flightIDs);
            }
        }


        if ($createdFrom && $createdTo){
            $prl->whereBetween("created_at", [$createdFrom, $createdTo]);
        }
        else {
            if ($createdFrom){
                $prl->where(DB::raw("DATE(created_at)"), $createdFrom);
            }
            if ($createdTo){
                $prl->where(DB::raw("DATE(created_at)"), $createdTo);
            }
        }

        return $prl->get();
    }

    public static function getFlightsActPassengers($flightIDs = null, $firstName = null, $lastName = null){
        $pax = PassengerFlightAct::with([
                                    'flight',
                                    'flight.flightNumber',
                                    'flight.flightNumber.airline',
                                    'flight.flightNumber.departureAirport',
                                    'flight.flightNumber.arrivalAirport',
                                    'passenger',
                                    'passengerFlight',
                                    'passengerFlight.flightFareBasis',
                                    'flightRbd',
                                    'flightCabin',
                                    'passengerOrder',
                                    'passengerFrequentFlyer',
                                    'passengerFrequentFlyer.airline',
                                    'fareCurrency',
                                    'flightFareBasis',
                                ]);

        if ($firstName || $lastName){
            $pax->join('passengers', 'passengers__flights_act.passenger_id', '=', 'passengers.id');

            if ($firstName){
                $pax->where("passengers.first_name", "LIKE", $firstName."%");
            }

            if ($lastName){
                $pax->where("passengers.last_name", "LIKE", $lastName."%");
            }
        }

        $pax->whereNull("passengers__flights_act.deleted_at");

        if ($flightIDs){
            if (is_array($flightIDs)){
                if (count($flightIDs)){
                    $pax->whereIn("flight_id", $flightIDs);
                }
            }
            else {
                $pax->where("flight_id", $flightIDs);
            }
        }

        return ($firstName || $lastName) ? $pax->get(["passengers__flights_act.*"]) : $pax->get();
    }

    public static function transferPassengers($paxAct, $transfer){
        $transferList = [];

        if (!$transfer || (is_array($transfer) && !count($transfer))){
            return $paxAct;
        }

        if (is_array($transfer)) {
            $onlyInbound = in_array("ib", $transfer);
            $onlyOutbound = in_array("ob", $transfer);
        }
        else {
            $onlyInbound = $transfer == "ib";
            $onlyOutbound = $transfer == "ob";
        }

        foreach ($paxAct as $each) {

            if ($onlyInbound & !count($each->combined_info["inbound"])){
                continue;
            }

            if ($onlyOutbound & !count($each->combined_info["outbound"])){
                continue;
            }

            $transferList[] = $each;
        }

        return $transferList;
    }

    public static function ssrPassengers($paxAct, $searchSSR){
        $ssrPassengerList = [];

        if (!$searchSSR || (is_array($searchSSR) && !count($searchSSR))){
            return $paxAct;
        }

        foreach ($paxAct as $each) {

            $paxSSR = $each->combined_info["ssr"];

            if (!count($paxSSR) || count($paxSSR) < count($searchSSR)){
                continue;
            }


            if (count(array_diff($searchSSR, $paxSSR))){
                continue;
            }

            $ssrPassengerList[] = $each;
        }

        return $ssrPassengerList;
    }

    public static function combinePassengersPlannedAndAct(&$paxAct, $paxPlanned, $onlyTransferInfo = false)
    {
        foreach ($paxAct as &$each) {

            $combined = [];
            $passengerFlight = null; // $paxPlanned->where("flight_id", $each->flight_id)->where("passenger_id", $each->passenger_id)->first();

            // FROM PNL
            $each->from_pnl = ($passengerFlight != null);

            if (!$onlyTransferInfo) {
                // FQTV
                $fqtv = "";
                if ($each->passengerFrequentFlyer) {
                    $fqtv = $each->passengerFrequentFlyer->airline ? $each->passengerFrequentFlyer->airline->iata . "-" : "";
                    $fqtv .= $each->passengerFrequentFlyer->ff_no;
                } elseif ($passengerFlight && $passengerFlight->passengerFrequentFlyer) {
                    $fqtv = $passengerFlight->passengerFrequentFlyer->airline ? $passengerFlight->passengerFrequentFlyer->airline->iata . "-" : "";
                    $fqtv .= $passengerFlight->passengerFrequentFlyer->ff_no;
                }
                $combined["fqtv"] = $fqtv;

                // SPML
                $spml = "";
                if ($passengerFlight && $passengerFlight->spml) {
                    $spml = $passengerFlight->spml;
                }
                $combined['spml'] = $spml;

                // SSR
                $combined['ssr'] = $each->ssr ? explode(";", $each->ssr) : [];

                // CODE-SHARE
                $codeShare = [];
                if ($passengerFlight && $passengerFlight->codeshare_flight) {
                    $cShare = unserialize($passengerFlight->codeshare_flight);

                    foreach ($cShare as $var => $iEach) {
                        $codeShare[$var] = $iEach;
                    }
                }
                $combined['codeshare'] = $codeShare;
            }

            // INBOUND
            $inbound = [];
            if ($each->inbound) {
                $iBound = unserialize($each->inbound);

                foreach ($iBound as $var => $iEach) {
                    $inbound[$var] = $iEach;
                }
            } elseif ($passengerFlight && $passengerFlight->inbound) {
                $iBound = unserialize($passengerFlight->inbound);

                foreach ($iBound as $var => $iEach) {
                    $inbound[$var] = $iEach;
                }
            }
            $combined['inbound'] = $inbound;

            // OUTBOUND
            $outbound = [];
            if ($each->outbound)
            {
                $oBound = unserialize($each->outbound);

                foreach ($oBound as $var => $oEach) {
                    $outbound[$var] = $oEach;
                }
            }
            elseif ($passengerFlight && $passengerFlight->outbound) {
                $oBound = unserialize($passengerFlight->outbound);

                foreach ($oBound as $var => $iEach) {
                    $outbound[$var] = $iEach;
                }
            }
            $combined['outbound'] = $outbound;

            $each->combined_info = $combined;

        }
    }
}
