<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * Created by PhpStorm.
 * User: Compas
 * Date: 27.08.14

 */

use Illuminate\Support\Facades\DB;

class Passenger extends Eloquent
{
    protected $table = "passengers";
    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public $timestamps = TRUE;

    public function passengerFlight()
    {
        return $this->hasMany("App\\Models\\PassengerFlight", "passenger_id");
    }

    public function pob(){
        return $this->hasOne('App\\Models\\Country', 'id', 'pob_country_id');
    }

    public function nationality(){
        return $this->hasOne('App\\Models\\Nationality', 'id', 'nationality_id');
    }

    public function passport(){
        return $this->belongsTo('App\\Models\\Country', 'passport_country_id');
    }

    public function passengerLanguages(){
        return $this->hasMany('App\\Models\\PassengerLanguage', 'passenger_id');
    }

    public function passengerOrder()
    {
        return $this->hasMany("App\\Models\\PassengerOrder", "passenger_id");
    }

    public function getFullNameAttribute(){
        return $this->attributes['first_name']." ".$this->attributes['last_name'];
    }

    public static function getFlightPassengersBySalesDate($departure_date, $flight_number = null, $sales_date = null){

        $sql1 = (isset($flight_number) ? " AND flight_number = '$flight_number'" : "");

        $sql2 = (isset($sales_date) ? " AND DATE(sales_date) = '$sales_date'" : "");
        $order2 = (isset($sales_date) ? " DATE(sales_date), " : "");

        $data = Passenger::selectRaw('passenger_id, sales_date, flight_number, departure_airport, arrival_airport, code, agency,first_name, last_name, s_passengers__flights.fare, coupon, status, ticket_number, s_passengers__orders.fare_basis')
            ->join('passengers__flights', 'passengers__flights.passenger_id', '=', 'passengers.id')
            ->join('flights__numbers', 'passengers__flights.flight_number_id', '=', 'flights__numbers.id')
            ->join('passengers__orders', 'passengers__flights.passenger_order_id', '=', 'passengers__orders.id')
            ->leftJoin('flights', 'passengers__flights.flight_id', '=', 'flights.id')
            ->leftJoin('agency__codes', 'agency__codes.id', '=', 'passengers__orders.agency_code_id')
            ->leftJoin('agency', 'agency__codes.agency_id', '=', 'agency.id')
            ->whereRaw("DATE(departure) = '$departure_date' $sql1 $sql2")
            ->orderByRaw("flight_number, $order2 last_name, first_name")
            ->get();

        return $data;
    }


    public static function getPassengerAllFlights($passenger_id){
        $data = Passenger::find($passenger_id)
            ->select([
                'agency_code_id',
                'order_status',
                'departure_airport',
                'arrival_airport',
                'ticket_number',
                'fare_basis',
                'passengers__flights.fare',
                'coupon',
                'first_name',
                'last_name',
                'picture',
                'thumb',
                'original_fare',
                'sales_date',
                'flight_number',
                DB::raw('DATE(std) as departure_date')])
            ->join('passengers__flights', 'passengers__flights.passenger_id', '=', 'passengers.id')
            ->join('flights__numbers', 'passengers__flights.flight_number_id', '=', 'flights__numbers.id')
            ->join('flights', 'passengers__flights.flight_id', '=', 'flights.id')
            ->join('passengers__orders', 'passengers__flights.passenger_order_id', '=', 'passengers__orders.id')
            ->join('flights__order_status', 'flights__order_status.id', '=', 'passengers__flights.flight_order_status_id')
            ->join('flights__fare_basis', 'flights__fare_basis.id', '=', 'passengers__flights.flight_fare_basis_id')
            ->leftJoin('flights__rbd', 'flights__rbd.id', '=', 'passengers__flights.flight_rbd_id')
            ->leftJoin('flights__types', 'flights__types.id', '=', 'flights__numbers.flight_type_id')
//            ->whereRaw("s_passengers.id = '$passenger_id' ")
            ->orderBy('sales_date')
            ->get();

        return $data;
    }


    public static function getPLList($flightId, $flightNumberId, $stdDate, $type = PNL){
        if (!$flightId || !$flightNumberId)
        {
            return response()->json([
                "error"   => TRUE,
                "message" => "No found required params, please check you request data",
                "title"   => "Validation Errors:"
            ]);
        }

        $table = $type == PNL ? "passengers__flights" : "passengers__flights_act";

        $passengers = Passenger::select([
            "passengers.id",
            "{$table}.id as passenger_flight_id",
            "{$table}.parent_id as inf_parent_id",
            "is_inf",
            "first_name",
            "last_name",
            "gender",
            "ticket_number",
            "coupon",
            "dob",
            "passport_country_id",
            "passport_num",
            "passport_dex",
            "passengers.address",
            "passengers.resident_country_id",
            "seat_number",
            "flights__cabin.abbr as cabin",
            "ptm_name_str",
            "ptm_pax",
            "baggage_pcs",
            "baggage_weight",
            "tag_number",
            "seq_no",
            "group_tcp",
            "xbag_qty",
            "xbag_wt",
            "xbag_info",
            "outbound",
            "inbound",
            "pnr",
            "airlines.iata as ff_airline",
            "ff_no",
        ])
            ->join("{$table}", "{$table}.passenger_id", "=", "passengers.id")
            ->leftJoin("passengers__orders", "{$table}.passenger_order_id", "=", "passengers__orders.id")
            ->leftJoin("passengers__frequent_flyers", "{$table}.passenger_frequent_flyer_id", "=", "passengers__frequent_flyers.id")
            ->leftJoin("airlines", "passengers__frequent_flyers.airline_id", "=", "airlines.id")
            ->leftJoin("flights__fare_basis", "{$table}.flight_fare_basis_id", "=", "flights__fare_basis.id")
            ->leftJoin("flights__rbd", "{$table}.flight_rbd_id", "=", "flights__rbd.id")
            ->leftJoin("flights__cabin", "{$table}.flight_cabin_id", "=", "flights__cabin.id")
            ->leftJoin("flights__order_status", "{$table}.flight_order_status_id", "=", "flights__order_status.id")
            ->whereNull("{$table}.deleted_at")
            ->where(function($sql) {
                $sql->whereNull("order_status")
                    ->orWhereIn("order_status", ["F", "O"]);
//                    ->orWhere(function($sql2){
//                        $sql2->whereNotNull("order_status")
//                            ->whereIn("order_status", ["F", "O"]);
//                    });
            })
            ->where(function($sql) use ($flightId, $stdDate, $flightNumberId, $table){
                $sql->where("{$table}.flight_id", "=", $flightId)
                    ->orWhere(function($sql2) use ($stdDate, $flightNumberId, $table) {
                        $sql2->where("{$table}.departure_date", $stdDate)
//                        $sql2->where(DB::raw("DATE(s_{$table}.departure)"), $stdDate)
                            ->where("{$table}.flight_number_id", "=", $flightNumberId);
                    });
            })
            ->orderBy("seq_no", "desc")
            ->orderBy("group_tcp", "desc")
            ->orderBy("id")
            ->get()
            ->toArray();

        $pl = $plInf = $plOutbound = $plInbound = $plDetails = $plXBag = $plDocs = $seqNos = [];

        $countries = Country::pluck("abbr", "id")->all();
        $countriesISO = Country::pluck("iso_alpha_3", "id")->all();

        $processedIDs = [];
        foreach ($passengers as $n => $each) {

            if (in_array($each['id'], $processedIDs)){
                continue;
            }

            $processedIDs[] = $each['id'];

            if ($each['is_inf']){
                $plInf[] = $each;
                continue;
            }

            if ($each['seq_no']){
                $i = $each['seq_no'];
                while(in_array($i, $seqNos)) {
                    $i++;
                };
            }
            else {
                $i = $n;
                while(in_array($i, $seqNos)) {
                    $i++;
                };
            }
            $seqNos[] = $i;

            $pl[$i] = [];

            foreach ($each as $j => $value) {
                if (in_array($j, ["xbag_info", "outbound", "inbound"]) && $value) {

                    $pl[$i][$j] = unserialize($value);
                    continue;
                }
                $pl[$i][$j] = $value;
            }
            if ($each['baggage_pcs'] || $each['resident_country_id']){
                if ($each['resident_country_id']){
                    if (isset($countries[$each["resident_country_id"]])) {
                        $pl[$i]["resident_country"] = $countries[$each["resident_country_id"]];
                    }
                    elseif (isset($countriesISO[$each["resident_country_id"]])) {
                        $pl[$i]["resident_country"] = $countriesISO[$each["resident_country_id"]];
                    }
                }
                $plDetails[] = $pl[$i];
            }


            if ($each['xbag_wt']){
                $plXBag[] = $pl[$i];
            }
            if ($each['outbound']){
                $plOutbound[] = $pl[$i];
            }
            if ($each['inbound']){
                $plInbound[] = $pl[$i];
            }
            if ($each['passport_num'])
            {
                if ($each['passport_country_id']){
                    if (isset($countries[$each["passport_country_id"]])) {
                        $pl[$i]["passport_country"] = $countries[$each["passport_country_id"]];
                    }
                    elseif (isset($countriesISO[$each["passport_country_id"]])) {
                        $pl[$i]["passport_country"] = $countriesISO[$each["passport_country_id"]];
                    }
                }
                $pl[$i]["passport_num"] = "***".substr($each['passport_num'], -3);

                if ($each["passport_dex"]){
                    $pl[$i]["passport_dex"] = "***".substr($each['passport_dex'], -5);
                }
                if ($each["dob"]){
                    $pl[$i]["dob"] = "***".substr($each['dob'], -5);
                }
                $plDocs[] = $pl[$i];
            }
        }

        foreach ($plInf as $each) {
            $index = null;
            foreach ($pl as $j => $passenger) {
                if ($passenger['passenger_flight_id'] == $each['inf_parent_id']){
                    $index = $j;
                    break;
                }
            }
            if ($index){
                if (!isset($pl[$index]['inf'])){
                    $pl[$index]['inf'] = [];
                }
                $pl[$index]['inf'][] = $each;
            }
        }

        ksort($pl);
        ksort($plXBag);
        ksort($plDetails);
        ksort($plOutbound);
        ksort($plInbound);
        ksort($plDocs);

        return [
            "pl"          => array_values($pl),
            "plInf"       => $plInf,
            "plDetails"   => array_values($plDetails),
            "plXBag"      => array_values($plXBag),
            "plOutbound"  => array_values($plOutbound),
            "plInbound"   => array_values($plInbound),
            "plDocs"      => array_values($plDocs),
        ];
    }
}
