<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class OrganizationLevel extends Eloquent{

    protected $table = "organization__level";

    public $timestamps = true;

    public function details(){
        return $this->hasMany('App\Models\OrganizationLevelDetails', 'organization_level_id');
    }

    /**
     * Get Employees By Level Id, Array Key: { User Ids /or Organization Ids }
     * @param $levelId
     * @param bool|false $accountable_staff
     * @param bool|false $organization_ids
     * @return array
     */
    public static function getEmployeesByLevelId($levelId, $accountable_staff = false, $organization_ids = false){
        $search_attr = ['organization_level_id' => $levelId];
        $users = [];

        if ($accountable_staff){
            $search_attr['support_staff'] = 0;
        }
        $organization = Organization::with(['user', 'position']);

        foreach ($search_attr as $attr => $each) {
            $organization->where($attr, $each);
        }
        $organization = $organization->get();

        if ($organization) {
            foreach ($organization as $each) {
                $user = $each->user;
                if ($organization_ids)
                    $users[$each->id] = $user->first_name . " " . $user->last_name . '/' . $each->position->name . '/';
                else
                    $users[$user->id] = $user->first_name . " " . $user->last_name . '/' . $each->position->name . '/';
            }
        }

        return $users;
    }

}
