<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

class Organization extends Eloquent{

    protected $table = "organization";

    public $timestamps = true;

    protected $fillable = [
        'user_id',
        'structure_department_id',
        'structure_position_id'
    ];

    public function details(){
        return $this->hasMany('App\Models\OrganizationDetails', 'organization_id');
    }

    public function relatedTables(){
        return $this->belongsToMany('App\Models\Table', 'organization__details', 'organization_id', 'table_id');
    }

    public function user(){
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function reportToUser(){
        return $this->belongsTo('App\Models\User', 'report_to_user_id');
    }

    public function reportTo(){
        return $this->hasMany('App\Models\Organization', 'report_to_user_id', 'user_id');
    }

    public function organizationLevel(){
        return $this->belongsTo('App\Models\OrganizationLevel', 'organization_level_id');
    }

    public function position(){
        return $this->belongsTo('App\Models\Position', 'structure_position_id');
    }

    /**
     * Get All Reporting To THe Given Id Employees
     * @param bool $organization_id
     * @param bool $userId
     * @return array
     */
    public static function getAllReportToEmployees($organization_id = FALSE, $userId = FALSE){
        if ($organization_id){
            $org = Organization::find($organization_id);
        }
        else if ($userId){
            $org = Organization::where('report_to_user_id',$userId)->get();
        }
        else
            return null;

        if (isset($org) && $org) {
            $org = ($org instanceof Collection) ? $org : [$org];
            foreach ($org as $item) {
                if ($item instanceof Organization) {
                    $total[] = clone $item;
                    $reportTo = $item->reportTo;
                    if ($reportTo) {
                        foreach ($reportTo as $each) {
                            $total[] = $each;
                            $total[] = self::getAllReportToEmployees(FALSE, $each->user_id);
                        }
                    }
                }
            }
            return isset($total) ? $total : null;
        }
        return null;
    }

    public static function getAllDirectReportees($organization_id = FALSE, $userId = FALSE, $with = []){
        if ($organization_id == null && $userId == null){
            return null;
        }

        if ($organization_id){
            $org = Organization::find($organization_id);
            if (count($with) > 0){
                return Organization::with($with)->where("report_to_user_id", $org->user_id)->get();
            }
            return Organization::with(['user'])->where("report_to_user_id", $org->user_id)->get();
        }
        else if ($userId){
            if (count($with) > 0){
                return Organization::with($with)->where("report_to_user_id", $userId)->get();
            }
            return Organization::where('report_to_user_id',$userId)->get();
        }

    }

    public static function listNotAssignedUsers($findAttributes = [], $selectCase = FALSE){
        $result = User::select([
            'users.id',
            DB::raw('CONCAT(first_name," ",last_name) AS full_name')
        ])
            ->join('users__departments', 'users__departments.user_id', '=', 'users.id')
            ->leftJoin('organization', 'organization.user_id', '=', 'users.id')
            ->whereNull('organization.id')
            ->whereNull('vs')
            ->orderBy('first_name');

        if (count($findAttributes)){
            foreach ($findAttributes as $attr =>$each) {
                $result->where($attr, $each);
            }
        }

        $result = $result->pluck('full_name', 'id')->all();

        return $selectCase ? ['' => 'Select'] + $result : $result;
    }

    /**
     * Get Organization JSON for Chart
     * @param $organization
     * @return string
     */
    public static function getOrganizationJsonForChart($organization){
        $data = [];

        // Get User Ids Array
        $arrayUserIds = self::getArrayUserId($organization);

        foreach ($organization as $i => $each) {
            $bgColor = $each->organizationLevel ? $each->organizationLevel->bg_color : '#ffad99';
            $user = $each->user;
            $picture = $user ? $user->picture : 'profile.png';

            $item = new \stdClass();
            $item->id = $arrayUserIds[$each->user_id];
            $reportToUserId =  $each->report_to_user_id;


            $item->parent = $reportToUserId ? (isset($arrayUserIds[$reportToUserId]) ? $arrayUserIds[$reportToUserId] : null) : null;
            $item->description = ($each->position ? '<a href="'.url("organization/new-chart/{$each->id}").'">'.$each->position->name.'</a>' : '');
            $item->email = $user ? $user->email : '';
            $item->groupTitleColor = $bgColor;
            $item->image = asset("storage/users/$picture");
            $item->itemTitleColor = $bgColor;
            $item->phone = $user ? $user->phone : '';
            $item->title = $user ? '<a href="'. url("user/{$each->user_id}") .'">'.$user->first_name . " " . $user->last_name.'</a>' : "";

            if ($each->report_to_user_id) {
                $item->title .= '<a href="' . url("organization/new-chart/user/{$each->report_to_user_id}") . '">' .
                    '<span style="float:right" class="glyphicon glyphicon-chevron-up"></span>' .
                    '</a>';
            }

            $item->label = $user ? $user->first_name . " " . $user->last_name : "";

            $data[] = $item;

        }
        return json_encode($data);
    }

    public static function getArrayUserId($organization){
        $array = [];
        $j = 0;
        foreach ($organization as $each) {
            if (!isset($array[$each->user_id]))
                $array[$each->user_id] = $j++;
        }
        return $array;
    }



}
