<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Notification extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "notifications";

    public $timestamps = true;

    public function updatedBy(){
        return $this->belongsTo('App\Models\User', "updated_by");
    }

    public function createdBy(){
        return $this->belongsTo('App\Models\User', "created_by");
    }


    public static function getTypes(){
        return [
            1   => "Staff License",
        ];
    }

    public static function getPeriods($type = false){

        if ($type){
            switch($type){
                case "DATE":
                    return [
                        0   => null,
                        1   => date("Y-m-d", strtotime("+ 1 days")),
                        2   => date("Y-m-d", strtotime("+ 7 days")),
                        3   => date("Y-m-d", strtotime("+ 14 days")),
                        4   => date("Y-m-d", strtotime("+ 30 days")),
                        5   => date("Y-m-d", strtotime("+ 60 days")),
                        6   => date("Y-m-d", strtotime("+ 90 days")),
                    ];

                case "TITLE":
                    return [
                        0   => "",
                        1   => "Daily reminder",
                        2   => "7 days reminder",
                        3   => "14 days reminder",
                        4   => "30 days reminder",
                        5   => "60 days reminder",
                        6   => "90 days reminder",
                    ];
            }

        }

        return [
            0   => "Select period",
            1   => "1 day prior",
            2   => "7 days prior",
            3   => "14 days prior",
            4   => "30 days prior",
            5   => "60 days prior",
            6   => "90 days prior",
        ];
    }


}
