<?php namespace App\Models;
use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */

class Module extends Eloquent
{
    protected $table = "modules";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at",
        "deleted_at"
    ];

    public function department()
    {
        return $this->belongsTo("App\\Models\\Department", "department_id");
    }

    public function permission()
    {
        return $this->hasMany("App\\Models\\ModulePermission", 'module_id');
    }

    public static function getCategories(){
        $categories = Module::whereNotNull("category")
                        ->where("category", "!=", "")
                        ->groupBy("category")
                        ->get(["category"]);

        $result = [];
        foreach ($categories as $each) {
            $result[$each->category] = $each->category;
        }

        return $result;
    }

    public static function getModulesByCategory(){
        $modules = Module::orderBy("dashboard", "DESC")
                        ->orderBy("category")
                        ->orderBy("name")
                        ->get();

        $result = [];
        foreach ($modules as $each) {
            if (!isset($result[$each->category])){
                $result[$each->category] = [];
            }

            $result[$each->category][] = $each;
        }

        return $result;
    }

    public static function getSubcategories(){
        $subcategories = Module::whereNotNull("subcategory")
            ->where("subcategory", "!=", "")
            ->groupBy("subcategory")
            ->get(["subcategory"]);

        $result = [];
        foreach ($subcategories as $each) {
            $result[$each->subcategory] = $each->subcategory;
        }

        return $result;
    }

    public static function getPermittedUserModulesArray(){

        $user = Auth::user();

        if (!$user){
            return null;
        }

        $lang = App::getLocale();
        $isEng = $lang == "en";

        $usersModules = UserModule::getAuthUserModule();

        $modulesList = Module::getModulesByCategory();

        $result[] =  [
            "icon" 		=> "fa-chevron-down",
            "title" 	=> $isEng ? "MENU" : trans("modules.".createLangString("MENU")),
        ];

        $categoryIcons = [
            "Dashboard"         => "fa-home",
            "Admin"             => "fa-pencil-square-o",
            "OCC"               => "fa-file-text-o",
            "HR"                => "fa-sitemap",
//            "Finance"           => "fa-chart-bar",
        ];

        $quickLinks = [];
        $quickLinks[] = [
            "title" 	=> $isEng ? "QUICK LINKS" : trans("modules.".createLangString("QUICK LINKS")),
            "icon"		=> "fa-chevron-down"
        ];


        foreach ($modulesList as $category => $modules) {

            $foundEntry = false;

            $item = [
                "title"     => $isEng ? $category : trans("modules.".createLangString($category)),
                "icon"      => isset($categoryIcons[$category]) ? $categoryIcons[$category] : "fa-folder-o",
                "sub"       => [],
            ];

            $url = "";
            foreach ($modules as $module) {

                // Hide
                if (in_array($module->name, [MODULES, USERS_MODULES, USERS_TRACKING ])){
                    if ($user->id == 474 && $module->name == USERS_TRACKING){
                        //
                    }
                    else {
                        if ($user->user_role_id != 4) {
                            continue;
                        }
                    }
                }

                $accessible = $module->open_module || in_array($module->id, $usersModules);

                if ($accessible){

                    $url = $module->link;

                    self::prepareModuleItem($item, $quickLinks, $module, $category, $categoryIcons, $url, $isEng);

                    $foundEntry = true;
                }
                // Exceptions
                else {

                    if ($module->name == AIRLINE_LIBRARY){

                        $url = "airline-library";

                        self::prepareModuleItem($item,  $quickLinks, $module, $category, $categoryIcons, $url, $isEng);

                        $foundEntry = true;
                    }
                }
            }

            if ($category == DASHBOARD){
                $item = [
                    "title"     => $isEng ? $category : trans("modules.".createLangString($category)),
                    "icon"      => isset($categoryIcons[$category]) ? $categoryIcons[$category] : "fa-folder-o",
                    "url"       => $url,
                ];
            }

            if ($foundEntry){
                $result[] = $item;
            }
        }

        $result = array_merge($result, $quickLinks);

        return $result;
    }

    static function prepareModuleItem(&$item, &$quickLinks, $module, $category, $categoryIcons, $url, $isEng){
        $days3 = strtotime("now");

        $created = strtotime($module->created_at) + (3 * 24 * 60 * 60);

        $nameCol = $module->subcategory && $module->subname ? "subname" : "name";
        $nameColLang = $nameCol == "name" ? "lang" : "subname_lang";
        $name = $isEng ? $module->{$nameCol} : trans("modules.{$module->$nameColLang}");
        $moduleName = $module->lang;

        $moduleData = [
            "title"     => $name . ( $created > $days3 ? "<span class='badge bg-color-red margin-left-5'>New</span>" : "" ),
            "icon"      => $module->icon ? $module->icon : "fa fa-arrow-right",
            "url"       => $url,
        ];

        if ($module->open_new_tab){
            $moduleData["url_target"] = "_blank";
        }

        if ($module->quick_links){
            $quickLinks[] = $moduleData;
        }

        if ($module->subcategory){

            if (!isset($item["sub"][$module->subcategory])){
                $item["sub"][$module->subcategory] = [
                    "title"     => $isEng ? $module->subcategory : trans("modules.{$module->subcategory_lang}"),
                    "icon"      => isset($categoryIcons[$category]) ? $categoryIcons[$category] : "fa-folder-o",
                    "sub"       => [],
                ];
            }

            $item["sub"][$module->subcategory]["sub"][$moduleName] = $moduleData;
        }
        else {
            $item["sub"][$moduleName] = $moduleData;
        }

        return $item;
    }
}
