<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class MhbBaggage extends Eloquent{

    protected $table = "mhb__baggage";

    public $timestamps = true;

    public function carrier(){
        return $this->belongsTo('App\\Models\\Airline', 'carrier_id');
    }

    public function brandName(){
        return $this->belongsTo('App\\Models\\BaggageBrand', 'brand_name_id');
    }

    public function type(){
        return $this->belongsTo('App\\Models\\BaggageType', 'baggage_type_id');
    }

    public function color(){
        return $this->belongsTo('App\\Models\\BaggageColor', 'baggage_color_id');
    }

    public function details(){
        return $this->hasMany('App\\Models\\MhbBaggageDetail', 'mhb_baggage_id');
    }


}
