<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */
class Maintenance extends Eloquent
{
    protected $table = "aircraft__maintenance";
    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];
    public $timestamps = TRUE;

    public function aircraft()
    {
        return $this->belongsTo("App\\Models\\Aircraft", "aircraft_id");
    }

    public function user()
    {
        return $this->belongsTo("App\\Models\\User", "user_id");
    }

    public static function getByAirline($airline){
        $maintenance = Maintenance::with(["aircraft"])
            ->join("aircraft", "aircraft.id", "=", "aircraft__maintenance.aircraft_id")
            ->where("airline_id", $airline->id)
            ->orderBy('departure_time', "DESC")
            ->get();

        return $maintenance;
    }

    /**
     * Get maintenance list form start date and end date
     * @param $startDate
     * @param $endDate
     * @return mixed
     */
    public static function maintenanceRange($startDate, $endDate)
    {
        $maintenance = Maintenance::with("aircraft")
            ->whereRaw("(s_aircraft__maintenance.arrival_time <= \"$startDate\" AND s_aircraft__maintenance.departure_time BETWEEN \"$startDate\" AND \"$endDate\") " .
                "OR ((s_aircraft__maintenance.arrival_time BETWEEN \"$startDate\" AND \"$endDate\") AND s_aircraft__maintenance.departure_time >= \"$endDate\") " .
                "OR ((s_aircraft__maintenance.arrival_time BETWEEN \"$startDate\" AND \"$endDate\") AND (s_aircraft__maintenance.departure_time BETWEEN \"$startDate\" AND \"$endDate\")) " .
                "OR (s_aircraft__maintenance.arrival_time <= \"$startDate\" AND s_aircraft__maintenance.departure_time >= \"$endDate\")")
            ->get();

        return $maintenance;
    }

    public static function checkMaintenanceConflicts($aircraftId, $startDate, $finishDate, $id = false){
        $search = Maintenance::where('aircraft_id', $aircraftId)
        ->where(function($query) use ($startDate, $finishDate) {
            $query->where(function ($sql) use ($finishDate) {
                $sql->where('arrival_time', '<', $finishDate)
                    ->where('departure_time', '>', $finishDate);
            })->orWhere(function ($sql) use ($startDate) {
                $sql->where('arrival_time', '<', $startDate)
                    ->where('departure_time', '>', $startDate);
            })->orWhere(function ($sql) use ($startDate, $finishDate) {
                $sql->where('arrival_time', '>', $startDate)
                    ->where('departure_time', '<', $finishDate);
            });
        });

        if ($id){
            $search->where('id', '!=', $id);
        }

        $search = $search->get();

        if (count($search)) {
            return false;
        }

        return true;
    }
}
