<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

class LogFlightCrew extends Eloquent {
    protected $table = "log__flights__crew";
    public $timestamps = true;

    public function flight()
    {
        return $this->belongsTo("Flight", "flight_id");
    }

    /**
     * Create Flight Crew in Log
     * @param $userId
     * @param $flightId
     * @param bool $fields
     * @param bool $isStandby
     * @param bool $isDHC
     * @return FlightCrew
     */
    public static function createCrewItem($userId, $flightId, $fields = false, $isStandby = FALSE, $isDHC = FALSE)
    {
        $flightCrewLog                 = new LogFlightCrew();
        $flightCrewLog->flight_id      = $flightId;
        $flightCrewLog->user_id        = $userId;
        if ($fields && count($fields)){
            foreach ($fields as $name => $value) {
                $flightCrewLog->$name = $value;
            }
        }
        $flightCrewLog->is_standby     = $isStandby;
        $flightCrewLog->is_dhc         = $isDHC;
        $flightCrewLog->created_by     = Auth::user()->id;
        $flightCrewLog->save();
        return $flightCrewLog;
    }
}
