<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 25.08.14

 */

class Location extends Eloquent
{
    protected $table = "locations";
    public $timestamps = true;

    public function airport(){
        return $this->belongsTo('App\Models\Airport', 'airport_id');
    }

    public function city(){
        return $this->belongsTo('App\Models\City', 'city_id');
    }

    public static function locationAirports($keyLocationId = FALSE, $airports = []){
        $selectedId = $keyLocationId ? "locations.id" : "airports.id";

        $locations = Location::select(['airports.iata', "{$selectedId} AS id"])
                            ->join('airports', 'airports.id', '=', 'locations.airport_id');

        if (count($airports)){
            $locations->whereIn("airport_id", $airports);
        }

        return $locations->pluck('airports.iata', 'id')
                         ->all();
    }

    public static function getUserLocationAirport($locationID){
        $list = Location::join("airports", "airports.id", "=", "locations.airport_id")
                        ->where('locations.id', $locationID)
                        ->first([
                            "locations.id",
                            "airports.id as airport_id",
                            "airports.iata",
                            "airports.icao",
                        ]);

        return $list;
    }

    public static function getStaffAirportIDs(){
        $list = Location::pluck('airport_id')
                        ->all();

        return $list;
    }

    public static function listAirports($locationValue = "id", $airportKey = "iata"){
        $list = Location::select(["locations.{$locationValue} AS value", "airports.{$airportKey} AS key"])
                        ->join('airports', 'airports.id', '=', 'locations.airport_id')
                        ->pluck('value', 'key')
                        ->all();

        return $list;
    }

    public static function getStaffLocations(){
        return Location::with([
            "airport",
            "city",
            "city.country",
        ])
            ->get();
    }

}
