<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

use Illuminate\Support\Facades\Auth;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class LibraryView extends Eloquent implements AuditableContract{

    use Auditable;

//    protected $auditExclude = [
//        'updated_by',
//        'created_by',
//    ];

    protected $guarded = [
        "id"
    ];

    protected $table = "library_views";

    public $timestamps = true;

    public function library(){
        return $this->belongsTo(Library::class, "library_id");
    }

    public function airlineLibrary(){
        return $this->belongsTo(AirlineLibrary::class, "airline_library_id");
    }

    public function librarySign(){
        return $this->belongsTo(LibrarySign::class, "library_sign_id");
    }

    public function user(){
        return $this->belongsTo(User::class, "user_id");
    }

    public static function getAuthLibrarySignDocs($user, $unsignedOnly = false){
        $libraryViews = LibraryView::with([
            "library",
            "airlineLibrary",
        ])
//            ->leftJoin("library", "library_views.library_id", "=","library.id")
//            ->leftJoin("airlines__library", "library_views.library_id", "=","airlines__library.id")
//            ->whereNull("library.deleted_at")
            ->where("user_id", $user->id);

        if ($unsignedOnly){
            $libraryViews->whereNull("signed_at");
        }

        return $libraryViews->orderBy("created_at", "DESC")->get();
    }
}
