<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class LibrarySignDepartment extends Eloquent implements AuditableContract{

    use Auditable;

//    protected $auditExclude = [
//        'updated_by',
//        'created_by',
//    ];

    protected $guarded = [
        "id"
    ];

    protected $table = "library_sign_departments";

    public $timestamps = true;

    public function sign(){
        return $this->belongsTo(LibrarySign::class, "library_sign_id");
    }

    public function department(){
        return $this->belongsTo(Department::class, "department_id");
    }
}
