<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Library extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "library";

    public $timestamps = true;

    public function createdBy(){
        return $this->belongsTo(User::class, "created_by");
    }

    public function updatedBy(){
        return $this->belongsTo(User::class, "updated_by");
    }

    public function signs(){
        return $this->hasMany(LibrarySign::class, "library_id");
    }

    public function lastSign(){
        return $this->hasOne(LibrarySign::class, "library_id")->orderBy("created_at", "DESC");
    }

    public function department(){
        return $this->belongsTo(Department::class, "department_id");
    }
}
