<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.


 * Project: aviation.dev
 */
class HrmLeave extends Eloquent {
    protected $table = "hrm_holiday";
    public $timestamps = false;

    public static function isNotExist($userid, $fromDate, $ToDate){
          $container = HrmLeave::select(['id'])->where('user_id',$userid)
                                 ->where('from_date',$fromDate)
                                 ->where('to_date',$ToDate);
        if($container->first() != null){return false;}
        else return true;
    }
    public static function  checkAccessToLeave($userid,$fromDate){
        $query_result = HrmLeave::where('user_id',$userid)->max('from_date');
        $between_days = ceil(abs(strtotime($query_result) - strtotime($fromDate)) / 86400);

        if($between_days > 365){
            return true;
        }
        else return false;
    }


    public static  function getBusyWeeks($arrayOfYearMonths){
        $resultCount = array();

//===================================================================================Trasform native  HrmLeave table for usebility

            $userDepartmentId = User::find(Auth::id())->department()->first()['id'];
            $hasSubDepartmentId = UserDepartment::select(['subdepartment_id'])->where('user_id',Auth::id())->first()['subdepartment_id'];
            $arrayForTable = array();
            $hrmGetTable = HrmLeave::all();
            foreach($hrmGetTable as $index=>$row)
            {
                $otherEmployeeIdFromDepart = User::find($row['user_id'])->department()->first()['id'];
                $monthYear = date('M-y' , strtotime($row['from_date']));
                    if ($row['acceptance'] == 1 && $otherEmployeeIdFromDepart ==  $userDepartmentId && in_array(date('Y-m',strtotime($row['from_date'])),$arrayOfYearMonths))
                    {

                            if((date('d',strtotime($row['from_date'])) >= date('d' , strtotime('1970-01-01'))) && (date('d',strtotime($row['from_date'])) <= date('d' , strtotime('1970-01-07'))))
                            {
                                //debug(date('d',strtotime($row['from_date'])));
                                if($hasSubDepartmentId == NUll)
                                {
                                    $arrayForTable[$userDepartmentId][$monthYear]['first_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['first_week']  = count($arrayForTable[$userDepartmentId][$monthYear]['first_week']);;
                                }else{
                                    $arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['first_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['first_week']  = count($arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['first_week']);
                                }
                            }elseif(date('d',strtotime($row['from_date'])) >= date('d' , strtotime('1970-01-08')) && date('d' , strtotime($row['from_date'])) <= date('d',strtotime('1970-01-14'))){
                                if($hasSubDepartmentId == NUll)
                                {
                                    $arrayForTable[$userDepartmentId][$monthYear]['second_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['second_week']  = count($arrayForTable[$userDepartmentId][$monthYear]['second_week']);;
                                }else{
                                    $arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['second_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['second_week']  = count($arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['second_week']);;
                                }
                            }elseif(date('d',strtotime($row['from_date'])) >= date('d' , strtotime('1970-01-15')) && date('d' , strtotime($row['from_date'])) <= date('d',strtotime('1970-01-21'))){
                                if($hasSubDepartmentId == NUll)
                                {
                                    $arrayForTable[$userDepartmentId][$monthYear]['third_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['third_week']  = count($arrayForTable[$userDepartmentId][$monthYear]['third_week']);;
                                }else{
                                    $arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['third_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['third_week']  = count($arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['third_week']);;
                                }
                            }elseif(date('d',strtotime($row['from_date'])) >= date('d' , strtotime('1970-01-22')) && date('d' , strtotime($row['from_date'])) <= date('d',strtotime('1970-01-31'))){
                                if($hasSubDepartmentId == NUll)
                                {
                                    $arrayForTable[$userDepartmentId][$monthYear]['forth_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['forth_week']  = count($arrayForTable[$userDepartmentId][$monthYear]['forth_week']);;
                                }else{
                                    $arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['forth_week'][$row['user_id']][$row['from_date']] = $row['from_date'];
                                    $resultCount[$monthYear]['forth_week']  = count($arrayForTable[$userDepartmentId][$hasSubDepartmentId][$monthYear]['forth_week']);
                                }
                            }
                    }


            }
        foreach ($arrayOfYearMonths as $item)
            foreach($resultCount as $index=>$val){
            {
                if (date('M-y', strtotime($item)) != $index )
                {


                    $resultCount[date('M-y', strtotime($item))]['first_week']=0;
                    $resultCount[date('M-y', strtotime($item))]['second_week']=0;
                    $resultCount[date('M-y', strtotime($item))]['third_week']=0;
                    $resultCount[date('M-y', strtotime($item))]['four_week']=0;
                }if(!isset($resultCount[date('M-y', strtotime($item))]['first_week'])){
                    $resultCount[date('M-y', strtotime($item))]['first_week'] = 0;
                }if(!isset($resultCount[date('M-y', strtotime($item))]['second_week'])){
                    $resultCount[date('M-y', strtotime($item))]['second_week'] = 0;
                }if(!isset($resultCount[date('M-y', strtotime($item))]['third_week'])){
                    $resultCount[date('M-y', strtotime($item))]['third_week'] = 0;
                }if(!isset($resultCount[date('M-y', strtotime($item))]['forth_week'])){
                    $resultCount[date('M-y', strtotime($item))]['forth_week'] = 0;
                }
            }

        }
        debug($resultCount);


        /*   foreach($arrayOfYearMonths as $monthYer){


               $arrayForTable[$userDepartmentId][$monthYer]['first_week'] = NULL;
               $arrayForTable[$userDepartmentId][$monthYer]['second_week'] = NULL;
               $arrayForTable[$userDepartmentId][$monthYer]['third_week'] = NULL;
               $arrayForTable[$userDepartmentId][$monthYer]['forth_week'] = NULL;
               $result[$monthYer]['first_week']  = 0;
               $result[$monthYer]['second_week']  = 0;
               $result[$monthYer]['third_week']  = 0;
               $result[$monthYer]['forth_week']  = 0;

           }*/
                    return $resultCount;
      }
    public static function dbLeavesRows($yourDepartmentId){
           $dBgetter = HrmLeave::leftJoin('users__departments', function($join) {
                   $join->on('hrm_holiday.user_id', '=', 'users__departments.user_id');
               })
                   ->where('users__departments.department_id','=', $yourDepartmentId)->get();
        return $dBgetter;
    }
    public static function  addRowApprove($user_id,$type, $from, $to, $head_id){
            $row = new HrmLeave();
        $row->type = $type;
        $row->from_date = $from;
        $row->to_date = $to;
        $row->user_id = $user_id;
        $row->acceptance = 1;
        $row->head_id = $head_id;

        $row->save();
        return $row->id;
    }

    public static function addRowDisapprove($user_id,$type, $from, $to,  $head_id){
        $row = new HrmLeave();
        $row->type = $type;
        $row->from_date = $from;
        $row->to_date = $to;
        $row->user_id = $user_id;
        $row->acceptance = 2;
        $row->head_id = $head_id;

        $row->save();
        return $row->id;
    }
    public static function addRowAlternate($user_id,$type, $from, $to, $head_id){
        $row = new HrmLeave();
        $row->type = $type;
        $row->from_date = $from;
        $row->to_date = $to;
        $row->user_id = $user_id;
        $row->acceptance = 3;
        $row->head_id = $head_id;

        $row->save();
        return $row->id;
    }
    public static function departmentId($userId){
        $result = UserDepartment::find($userId)->department()->first()['id'];
        return $result;
    }
}
