<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class HomeChart extends Eloquent{

    protected $table = "homepage__charts";

    public $timestamps = true;

    protected $fillable = [
        'column_id',
        'chart_id',
        'chart_type_id',
        'height',
        'report_period_id',
        'date_from',
        'date_to',
        'type',
    ];

    public function chart(){
        return $this->belongsTo('App\Models\Chart', 'chart_id');
    }

    public function chartType(){
        return $this->belongsTo('App\Models\ChartType', 'chart_type_id');
    }


}
