<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */

class HolidayAirport extends Eloquent implements AuditableContract
{
    use Auditable;

    protected $table = "holidays_airports";

    public $timestamps = true;

    protected $guarded = ["id"];

    public function airport(){
        return $this->belongsTo(Airport::class);
    }
}
